/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.cec;

import com.ibm.hsc.cim.exceptions.HSCException;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.common.util.PparInfoPacker;
import com.ibm.hsc.websm.sysprofile.SysProfileInfo;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbemcfg.GlobalConfig;

public class CECInfo {
    public static final String KEY = "Name";
    public static final String NAME = "name";
    public static final String USER_DEFINED_NAME = "UserDefinedName";
    public static final String AFFINITY_CAPABILITY = "AffinityCapability";
    public static final String RUNTIME_CAPABILITY = "RuntimeCapability";
    public static final String CUOD_CAPABILITIES = "CUoDCapabilities";
    public static final String MAX_PARTITIONS = "LPARSlotCount";
    public static final String LPAR_MIN_MEMORY_SIZE = "LparMinMemorySize";
    public static final String LMB_SIZE = "LMBSize";
    public static final String POWER_OFF_POLICY = "PowerOffPolicy";
    public static final String SURVEILLANCE_POLICY = "CspSurveillancePolicy";
    public static final String STATE = "State";
    public static final String PARTITION_STATE = "PartitionState";
    public static final String CAPABILITY = "Capability";
    public static final String MODEL = "Model";
    public static final String MODE = "Mode";
    public static final String SERIAL_NUMBER = "SerialNumber";
    public static final String INSTALLED_CPU_COUNT = "InstalledCPUCount";
    public static final String IO_DRAWER_COUNT = "IODrawerCount";
    public static final String INSTALLED_MEMORY = "InstalledMemory";
    public static final String OP_PANEL_WINDOW_COUNT = "OpPanelWindowCount";
    public static final String OP_PANEL_VALUE = "OpPanelValue";
    public static final String VIRTUAL_TTY_WINDOW_COUNT = "VirtualTTYWindowCount";
    public static final String CREATION_CLASS_NAME = "CreationClassName";
    public static final String PARTITION_CLASS_NAME = "IBMHSC_Partition";
    public static final String PROCESSOR_CLASS_NAME = "IBMHSC_Processor";
    public static final String IODRAWER_CLASS_NAME = "IBMHSC_IODrawer";
    public static final String PCISLOT_CLASS_NAME = "IBMHSC_PCISlot";
    public static final String COMP_LPAR_ASSO_CLASS_NAME = "IBMHSC_CompSysPartition";
    public static final String SLOT_KEY1 = "IODrawerSystemCreationClassName";
    public static final String SLOT_KEY2 = "IODrawerSystemName";
    public static final String SLOT_KEY3 = "IODrawerCreationClassName";
    public static final String SLOT_KEY4 = "IODrawerDeviceID";
    public static final String SLOT_KEY5 = "SlotID";
    public static final String CSP_VERSION = "CSPVersion";
    public static final String STATE_PROP = "state_PROP";
    public static final String MODE_PROP = "mode_PROP";
    public static final String AFFINITY_CAPABILITY_PROP = "affinityCapability_PROP";
    public static final String RUNTIME_CAPABILITY_PROP = "runtimeCapability_PROP";
    public static final String CUOD_CAPABILITIES_PROP = "cuodCapabilities_PROP";
    public static final String MAX_PARTITIONS_PROP = "maxNumberOfPartitions_PROP";
    public static final String LPAR_MIN_MEMORY_SIZE_PROP = "lparMinMemorySize_PROP";
    public static final String LMB_SIZE_PROP = "LMBSize_PROP";
    public static final String POWER_OFF_POLICY_PROP = "powerOffPolicy_PROP";
    public static final String PPARSETUP_PROP = "pparSetup_PROP";
    public static final String SURVEILLANCE_POLICY_PROP = "surveillancePolicy_PROP";
    public static final String POWERED_OFF_PROP = "poweredOff_PROP";
    public static final String POWER_ON_MODE_PROP = "powerOnMode_PROP";
    public static final String CAPABILITY_PROP = "capability_PROP";
    public static final String MODEL_TYPE_PROP = "modelType_PROP";
    public static final String SERIAL_NUMBER_PROP = "serialNumber_PROP";
    public static final String INSTALLED_CPU_COUNT_PROP = "installedCPUCount_PROP";
    public static final String INSTALLED_MEMORY_PROP = "installedMemory_PROP";
    public static final String IO_DRAWER_COUNT_PROP = "IODrawerCount_PROP";
    public static final String OP_PANEL_WINDOW_COUNT_PROP = "opPanelWindowCount_PROP";
    public static final String OP_PANEL_VALUE_PROP = "opPanelValue_PROP";
    public static final String VIRTUAL_TTY_WINDOW_COUNT_PROP = "virtualTTYWindowCount_PROP";
    public static final String CIM_OBJECT_PATH_PROP = "cimObjectPath_PROP";
    public static final String MEMORY_INFO_PROP = "memoryInfo_PROP";
    public static final String PROCESSOR_INFO_PROP = "processorInfo_PROP";
    public static final String IO_INFO_PROP = "ioInfo_PROP";
    public static final String UPDATE_CIMOM_PROP = "updateCimom_PROP";
    public static final String CSP_VERSION_PROP = "cspVersion_PROP";
    public static final short LPAR_RUNNING_STATE = 8;
    public static final short LPAR_BOOTING_STATE = 5;
    public static final short LPAR_OPEN_FIRMWARE_STATE = 9;
    public static final int SLOT_ASSIGNEMENT = 1;
    public static final short PROC_ASSIGNEMENT = 2;
    public static Hashtable CPU_STATUS_MAP = new Hashtable();
    public static Hashtable STATE_MAP;
    public static final String HSC_COMPUTER_SYSTEM = "IBMHSC_ComputerSystem";
    public static Vector KEY_LIST;
    public static final String IO_DRAWER_ASSOC = "IBMHSC_CompSysIODrawer";
    public static final String IO_DRAWER = "IBMHSC_IODrawer";
    public static final String DRAWER_SLOT_ASSOC = "IBMHSC_IODrawerSlotGroup";
    public static final String ALLOCATED_PROCESSOR = "IBMHSC_AllocatedProcessor";
    public static final String SLOT_GROUP = "IBMHSC_SlotGroup";
    public static final String DEVICE_ID = "DeviceID";
    public static final String IN_SLOT_GROUP = "IBMHSC_InSlotGroup";
    public static final String PCI_SLOT = "IBMHSC_PCISlot";
    public static final String ALLOCATED_SLOT = "IBMHSC_AllocatedSlot";
    public static final String CPU_STATUS = "CPUStatus";
    public static final String PARTITION_KEY_NAME = "Name";
    public static final String REF1 = "GroupComponent";
    public static final String REF2 = "PartComponent";
    public static final String REF3 = "Collection";
    public static final String REF4 = "Member";
    public static final String REF5 = "DrawerGroup";
    public static final String CLUSTER_SIZE = "ClusterSize";
    public static final String UPDATE_FLAG = "UpdateFlag";
    public static final String PHYS_LOC_CODES = "PhysLocCodes";
    public static final String PPAR_SLOT_IDS = "PPARSlotIDs";
    public static final String PPAR_NAMES = "PPARNames";
    public static final String PPAR_MEM_PROBLEM_STR = "MemoryProblemStr";
    public static final String PPAR_PROC_PROBLEM_STR = "ProcProblemStr";
    public static final String PARTITION_INFO = "PartitionInfo";
    public static final String PPAR_SLOT_ID = "PPARSlotID";
    public static final String RESOURCES = "Resources";

    public static Hashtable getCECInfo(String string) throws CIMException {
        CIMObjectPath cIMObjectPath = null;
        Hashtable<String, Hashtable> hashtable = null;
        cIMObjectPath = new CIMObjectPath(HSC_COMPUTER_SYSTEM);
        Enumeration enumeration = HscUtil.getCIMEnumInstances(string, cIMObjectPath, false);
        hashtable = new Hashtable<String, Hashtable>();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable2 = null;
            cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            CIMInstance cIMInstance = HscUtil.getCIMInstance(string, cIMObjectPath, false);
            if (cIMInstance == null) continue;
            String string2 = CECInfo.getKey(cIMObjectPath);
            hashtable2 = CECInfo.getAttributeValues(cIMInstance);
            if (CECInfo.pparSetup(cIMObjectPath, string)) {
                hashtable2.put(PPARSETUP_PROP, new Boolean(true));
            } else {
                hashtable2.put(PPARSETUP_PROP, new Boolean(false));
            }
            if (hashtable2 == null) continue;
            hashtable.put(string2, hashtable2);
        }
        return hashtable;
    }

    public static Hashtable getCECAttribute(String string, String string2) throws CIMException {
        Object object;
        CIMInstance cIMInstance;
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath(HSC_COMPUTER_SYSTEM);
        Vector vector = HscUtil.decodeKey(string2);
        if (KEY_LIST != null) {
            cIMInstance = vector.elements();
            object = KEY_LIST.elements();
            while (object.hasMoreElements()) {
                String string3 = (String)object.nextElement();
                cIMObjectPath.addKey(string3, new CIMValue((Object)((String)cIMInstance.nextElement())));
            }
        }
        if ((cIMInstance = HscUtil.getCIMInstance(string, cIMObjectPath, false)) != null) {
            object = CECInfo.getAttributeValues(cIMInstance);
            if (CECInfo.pparSetup(cIMObjectPath, string)) {
                ((Hashtable)object).put(PPARSETUP_PROP, new Boolean(true));
            } else {
                ((Hashtable)object).put(PPARSETUP_PROP, new Boolean(false));
            }
            return object;
        }
        return null;
    }

    public static Hashtable getParentsOfPartition(String string, String string2) throws CIMException {
        Hashtable hashtable = null;
        Vector vector = HscUtil.decodeKey(string2);
        Hashtable hashtable2 = CECInfo.getCECInfo(string);
        if (hashtable2 != null) {
            hashtable = new Hashtable();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!CECInfo._hasKey(string3, vector)) continue;
                hashtable.put(string3, hashtable2.get(string3));
            }
        }
        return hashtable;
    }

    public static Hashtable getParentsOfSystemProfile(String string, String string2) throws CIMException {
        Object object;
        CIMProperty cIMProperty;
        CIMInstance cIMInstance;
        Hashtable hashtable = null;
        Vector vector = HscUtil.decodeKey(string2);
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_SystemProfile");
        if (SysProfileInfo.KEY_LIST != null) {
            cIMInstance = vector.elements();
            cIMProperty = SysProfileInfo.KEY_LIST.elements();
            while (cIMProperty.hasMoreElements() && cIMInstance.hasMoreElements()) {
                object = (String)cIMProperty.nextElement();
                cIMObjectPath.addKey((String)object, new CIMValue((Object)((String)cIMInstance.nextElement())));
            }
        }
        if ((cIMInstance = HscUtil.getCIMInstance(string, cIMObjectPath, false)) != null) {
            cIMProperty = cIMInstance.getProperty("ComputerSystemName");
            object = cIMProperty.getValue();
            String string3 = (String)object.getValue();
            Hashtable hashtable2 = CECInfo.getCECInfo(string);
            if (hashtable2 != null) {
                hashtable = new Hashtable();
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    Vector vector2 = HscUtil.decodeKey(string4);
                    if (!vector2.contains(string3)) continue;
                    hashtable.put(string4, hashtable2.get(string4));
                }
            }
        }
        return hashtable;
    }

    public static Hashtable getAttributeValues(CIMInstance cIMInstance) {
        String string;
        short s;
        int n;
        Hashtable hashtable = CECInfo._initAttrValues();
        CIMObjectPath cIMObjectPath = HscUtil.constructPath(cIMInstance);
        hashtable.put(CIM_OBJECT_PATH_PROP, cIMObjectPath);
        hashtable.put("Name", CECInfo.getKey(cIMObjectPath));
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(USER_DEFINED_NAME);
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            hashtable.put(NAME, cIMValue.getValue());
        }
        if ((cIMProperty = cIMInstance.getProperty(POWER_OFF_POLICY)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            hashtable.put(POWER_OFF_POLICY_PROP, (Boolean)cIMValue.getValue());
        }
        if ((cIMProperty = cIMInstance.getProperty(SURVEILLANCE_POLICY)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            n = ((Number)cIMValue.getValue()).intValue();
            if (n == 0) {
                hashtable.put(SURVEILLANCE_POLICY_PROP, new Boolean(false));
            } else {
                hashtable.put(SURVEILLANCE_POLICY_PROP, new Boolean(true));
            }
        }
        if ((cIMProperty = cIMInstance.getProperty(STATE)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            n = ((Number)cIMValue.getValue()).intValue();
            hashtable.put(STATE_PROP, new Integer(n));
            if (n == 3) {
                hashtable.put(POWERED_OFF_PROP, new Boolean(true));
            }
        }
        if ((cIMProperty = cIMInstance.getProperty(MODE)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            n = ((Number)cIMValue.getValue()).intValue();
            hashtable.put(MODE_PROP, new Integer(n));
        }
        cIMProperty = cIMInstance.getProperty(CAPABILITY);
        n = 0;
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            n = ((Number)cIMValue.getValue()).shortValue();
        }
        hashtable.put(CAPABILITY_PROP, new Short((short)n));
        cIMProperty = cIMInstance.getProperty(CSP_VERSION);
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            hashtable.put(CSP_VERSION_PROP, (String)cIMValue.getValue());
        }
        if ((cIMProperty = cIMInstance.getProperty(MODEL)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            hashtable.put(MODEL_TYPE_PROP, (String)cIMValue.getValue());
        }
        if ((cIMProperty = cIMInstance.getProperty(SERIAL_NUMBER)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            hashtable.put(SERIAL_NUMBER_PROP, (String)cIMValue.getValue());
        }
        cIMProperty = cIMInstance.getProperty(AFFINITY_CAPABILITY);
        n = 0;
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            n = ((Number)cIMValue.getValue()).shortValue();
        }
        hashtable.put(AFFINITY_CAPABILITY_PROP, new Short((short)n));
        cIMProperty = cIMInstance.getProperty(RUNTIME_CAPABILITY);
        n = 0;
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            n = ((Number)cIMValue.getValue()).shortValue();
        }
        hashtable.put(RUNTIME_CAPABILITY_PROP, new Short((short)n));
        cIMProperty = cIMInstance.getProperty(MAX_PARTITIONS);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
            if (cIMValue != null) {
                n = ((Number)cIMValue.getValue()).shortValue();
            }
            hashtable.put(MAX_PARTITIONS_PROP, new Short((short)n));
        }
        if ((cIMProperty = cIMInstance.getProperty(LPAR_MIN_MEMORY_SIZE)) != null) {
            n = 0;
            cIMValue = cIMProperty.getValue();
            if (cIMValue != null) {
                n = ((Number)cIMValue.getValue()).shortValue();
            }
            hashtable.put(LPAR_MIN_MEMORY_SIZE_PROP, new Short((short)n));
        }
        if ((cIMProperty = cIMInstance.getProperty(LMB_SIZE)) != null) {
            n = 0;
            cIMValue = cIMProperty.getValue();
            if (cIMValue != null) {
                n = ((Number)cIMValue.getValue()).shortValue();
            }
            hashtable.put(LMB_SIZE_PROP, new Short((short)n));
        }
        cIMProperty = cIMInstance.getProperty(CUOD_CAPABILITIES);
        n = 0;
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            n = ((Number)cIMValue.getValue()).shortValue();
        }
        hashtable.put(CUOD_CAPABILITIES_PROP, new Short((short)n));
        cIMProperty = cIMInstance.getProperty(INSTALLED_CPU_COUNT);
        if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
            s = ((Number)cIMValue.getValue()).shortValue();
            hashtable.put(INSTALLED_CPU_COUNT_PROP, new Short(s));
        }
        if ((cIMProperty = cIMInstance.getProperty(IO_DRAWER_COUNT)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            s = ((Number)cIMValue.getValue()).shortValue();
            hashtable.put(IO_DRAWER_COUNT_PROP, new Short(s));
        }
        if ((cIMProperty = cIMInstance.getProperty(INSTALLED_MEMORY)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            long l = ((Number)cIMValue.getValue()).longValue();
            hashtable.put(INSTALLED_MEMORY_PROP, new Long(l));
        }
        if ((cIMProperty = cIMInstance.getProperty(OP_PANEL_WINDOW_COUNT)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            short s2 = ((Number)cIMValue.getValue()).shortValue();
            hashtable.put(OP_PANEL_WINDOW_COUNT_PROP, new Short(s2));
        }
        if ((cIMProperty = cIMInstance.getProperty(OP_PANEL_VALUE)) != null && (cIMValue = cIMProperty.getValue()) != null && (string = (String)cIMValue.getValue()) != null) {
            if (string.equals("CANNOT_GET_LED")) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CANNOT_GET_LED", "Can not get LED");
            }
            hashtable.put(OP_PANEL_VALUE_PROP, string);
        }
        if ((cIMProperty = cIMInstance.getProperty(VIRTUAL_TTY_WINDOW_COUNT)) != null && (cIMValue = cIMProperty.getValue()) != null) {
            short s3 = ((Number)cIMValue.getValue()).shortValue();
            hashtable.put(VIRTUAL_TTY_WINDOW_COUNT_PROP, new Short(s3));
        }
        return hashtable;
    }

    public static String getKey(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        String string = "";
        if (vector != null) {
            Enumeration enumeration = KEY_LIST.elements();
            block0: while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    CIMProperty cIMProperty = (CIMProperty)enumeration2.nextElement();
                    if (!string2.equals(cIMProperty.getName())) continue;
                    CIMValue cIMValue = cIMProperty.getValue();
                    string = string + cIMValue.getValue() + "~";
                    continue block0;
                }
            }
        } else {
            string = cIMObjectPath.toString();
        }
        return string;
    }

    public static boolean pparSetup(CIMObjectPath cIMObjectPath, String string) {
        block4: {
            try {
                Enumeration enumeration = HscUtil.getCIMAssociationInst(string, cIMObjectPath, COMP_LPAR_ASSO_CLASS_NAME, PARTITION_CLASS_NAME, REF1, REF2, true, false, null);
                if (enumeration == null) break block4;
                while (enumeration.hasMoreElements()) {
                    short s;
                    CIMValue cIMValue;
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    CIMProperty cIMProperty = cIMInstance.getProperty("PartitionType");
                    if (cIMProperty == null || (cIMValue = cIMProperty.getValue()) == null || (s = ((Number)cIMValue.getValue()).shortValue()) != 3 && s != 2) continue;
                    return true;
                }
            }
            catch (Throwable throwable) {
                if (IDebug.enabled()) {
                    // empty if block
                }
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private static boolean _hasKey(String string, Vector vector) {
        Object object;
        String string2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            int n = ((String)object).indexOf("*");
            if (n == -1) continue;
            string2 = ((String)object).substring(n + 1);
            break;
        }
        object = new StringTokenizer(string, "~", false);
        if (object != null) {
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (!string3.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static Hashtable _initAttrValues() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Name", "");
        hashtable.put(NAME, "");
        hashtable.put(CIM_OBJECT_PATH_PROP, new CIMObjectPath(HSC_COMPUTER_SYSTEM));
        hashtable.put(POWER_OFF_POLICY_PROP, new Boolean(false));
        hashtable.put(SURVEILLANCE_POLICY_PROP, new Boolean(false));
        hashtable.put(POWERED_OFF_PROP, new Boolean(false));
        hashtable.put(STATE_PROP, "");
        hashtable.put(CSP_VERSION_PROP, "");
        hashtable.put(AFFINITY_CAPABILITY_PROP, new Short(0));
        hashtable.put(RUNTIME_CAPABILITY, new Short(0));
        hashtable.put(MAX_PARTITIONS_PROP, new Short(16));
        hashtable.put(LPAR_MIN_MEMORY_SIZE_PROP, new Short(256));
        hashtable.put(LMB_SIZE_PROP, new Short(256));
        hashtable.put(CUOD_CAPABILITIES, new Short(0));
        hashtable.put(CAPABILITY_PROP, new Short(0));
        hashtable.put(MODEL_TYPE_PROP, "");
        hashtable.put(SERIAL_NUMBER_PROP, "");
        hashtable.put(INSTALLED_CPU_COUNT_PROP, new Short(0));
        hashtable.put(IO_DRAWER_COUNT_PROP, new Short(0));
        hashtable.put(INSTALLED_MEMORY_PROP, new Long(0L));
        hashtable.put(OP_PANEL_WINDOW_COUNT_PROP, new Short(0));
        hashtable.put(OP_PANEL_VALUE_PROP, "");
        hashtable.put(VIRTUAL_TTY_WINDOW_COUNT_PROP, new Short(0));
        return hashtable;
    }

    public static String convertSlotObj(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        String[] stringArray = new String[5];
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (SLOT_KEY1.equalsIgnoreCase(cIMProperty.getName())) {
                    stringArray[0] = (String)cIMProperty.getValue().getValue();
                    continue;
                }
                if (SLOT_KEY2.equalsIgnoreCase(cIMProperty.getName())) {
                    stringArray[1] = (String)cIMProperty.getValue().getValue();
                    continue;
                }
                if (SLOT_KEY3.equalsIgnoreCase(cIMProperty.getName())) {
                    stringArray[2] = (String)cIMProperty.getValue().getValue();
                    continue;
                }
                if (SLOT_KEY4.equalsIgnoreCase(cIMProperty.getName())) {
                    stringArray[3] = (String)cIMProperty.getValue().getValue();
                    continue;
                }
                if (!SLOT_KEY5.equalsIgnoreCase(cIMProperty.getName())) continue;
                Object object = cIMProperty.getValue().getValue();
                String string = null;
                string = object instanceof UnsignedInt8 ? ((UnsignedInt8)object).toString() : (String)object;
                stringArray[4] = string;
            }
        }
        return stringArray[0] + stringArray[1] + stringArray[2] + stringArray[3] + stringArray[4];
    }

    public static Hashtable getAssignedPartitions(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        Enumeration enumeration = HscUtil.getCIMAssociationInst(string, cIMObjectPath, COMP_LPAR_ASSO_CLASS_NAME, PARTITION_CLASS_NAME, REF1, REF2, true, false, null);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                UnsignedInt32 unsignedInt32;
                Vector vector;
                Object object;
                Object object2;
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(PARTITION_CLASS_NAME, cIMInstance.getKeyValuePairs());
                cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
                String string2 = null;
                try {
                    string2 = (String)cIMInstance.getProperty(USER_DEFINED_NAME).getValue().getValue();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                UnsignedInt8 unsignedInt8 = null;
                CIMProperty cIMProperty = cIMInstance.getProperty(PARTITION_STATE);
                CIMValue cIMValue = cIMProperty.getValue();
                if (cIMValue != null) {
                    unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                }
                if (string2 == null || unsignedInt8 == null || unsignedInt8.shortValue() != 8 && unsignedInt8.shortValue() != 5 && unsignedInt8.shortValue() != 9) continue;
                Enumeration enumeration2 = HscUtil.getCIMAssociation(string, cIMObjectPath2, ALLOCATED_SLOT, "IBMHSC_PCISlot", REF1, REF2);
                if (enumeration2 != null) {
                    while (enumeration2.hasMoreElements()) {
                        object2 = (CIMObjectPath)enumeration2.nextElement();
                        object = CECInfo.convertSlotObj((CIMObjectPath)object2);
                        hashtable4.put((String)object, string2);
                    }
                }
                if ((object2 = HscUtil.getCIMAssociation(string, cIMObjectPath2, ALLOCATED_PROCESSOR, PROCESSOR_CLASS_NAME, REF1, REF2)) != null) {
                    block4: while (object2.hasMoreElements()) {
                        object = (CIMObjectPath)object2.nextElement();
                        vector = object.getKeys();
                        if (vector == null) continue;
                        unsignedInt32 = vector.elements();
                        while (unsignedInt32.hasMoreElements()) {
                            CIMProperty cIMProperty2 = (CIMProperty)unsignedInt32.nextElement();
                            if (!DEVICE_ID.equalsIgnoreCase(cIMProperty2.getName())) continue;
                            String string3 = (String)cIMProperty2.getValue().getValue();
                            hashtable3.put(string3, string2);
                            continue block4;
                        }
                    }
                }
                object = new Vector();
                cIMProperty = cIMInstance.getProperty("AllocatedMemory");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    vector = null;
                    vector = (UnsignedInt32)cIMValue.getValue();
                    cIMProperty = cIMInstance.getProperty("PageTableMemory");
                    if (cIMProperty != null) {
                        cIMValue = cIMProperty.getValue();
                    }
                    unsignedInt32 = null;
                    if (cIMValue != null) {
                        unsignedInt32 = (UnsignedInt32)cIMValue.getValue();
                    }
                    if (vector != null) {
                        ((Vector)object).addElement(new Long(vector.longValue()));
                    } else {
                        ((Vector)object).addElement(new Long(0L));
                    }
                    if (unsignedInt32 != null) {
                        ((Vector)object).addElement(new Long(unsignedInt32.longValue()));
                    } else {
                        ((Vector)object).addElement(new Long(0L));
                    }
                }
                hashtable2.put(string2, object);
            }
        }
        hashtable.put("MEMORY", hashtable2);
        hashtable.put("PROCESSOR", hashtable3);
        hashtable.put("IO", hashtable4);
        return hashtable;
    }

    public static Hashtable getIoInfo(String string, CIMObjectPath cIMObjectPath, Hashtable hashtable) throws CIMException {
        Hashtable hashtable2;
        block8: {
            hashtable2 = new Hashtable();
            Enumeration enumeration = null;
            try {
                enumeration = HscUtil.getCIMAssociationInst(string, cIMObjectPath, IO_DRAWER_ASSOC, "IBMHSC_IODrawer", REF1, REF2, true, false, null);
                if (enumeration == null) break block8;
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_IODrawer", cIMInstance.getKeyValuePairs());
                    cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
                    String string2 = (String)cIMInstance.getProperty(DEVICE_ID).getValue().getValue();
                    Enumeration enumeration2 = HscUtil.getCIMAssociationInst(string, cIMObjectPath2, "IBMHSC_IODrawerSlot", "IBMHSC_PCISlot", REF1, REF2, true, false, null);
                    Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                    hashtable3.put("DRAWER_CIM_INSTANCE", cIMInstance);
                    hashtable2.put(string2, hashtable3);
                    if (enumeration2 == null) continue;
                    while (enumeration2.hasMoreElements()) {
                        Object object;
                        Hashtable hashtable4;
                        String string3;
                        CIMInstance cIMInstance2 = (CIMInstance)enumeration2.nextElement();
                        String string4 = null;
                        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMInstance2.getProperty("SlotId").getValue().getValue();
                        string4 = unsignedInt8.toString();
                        UnsignedInt8 unsignedInt82 = (UnsignedInt8)cIMInstance2.getProperty("PCIBus").getValue().getValue();
                        short s = unsignedInt82.shortValue();
                        string4 = "Slot_" + string4;
                        if (IDebug.enabled) {
                            IDebug.println((String)(" the slot id is,," + string4));
                        }
                        if (hashtable != null && (string3 = (String)hashtable.get(hashtable4 = CECInfo.convertSlotObj(object = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs())))) != null) {
                            string4 = string4 + " : " + string3;
                        }
                        if (s < 128) {
                            hashtable3.put(string4, cIMInstance2);
                            continue;
                        }
                        object = "Group_" + unsignedInt82.toString();
                        hashtable4 = null;
                        hashtable4 = (Hashtable)hashtable3.get(object);
                        if (hashtable4 == null) {
                            hashtable4 = new Hashtable();
                        }
                        hashtable4.put(string4, cIMInstance2);
                        hashtable3.put((String)object, hashtable4);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return hashtable2;
    }

    public static Hashtable getProcInfo(String string, CIMObjectPath cIMObjectPath, Hashtable hashtable) throws CIMException {
        Hashtable hashtable2 = null;
        Hashtable<String, String> hashtable3 = null;
        Hashtable hashtable4 = null;
        Enumeration enumeration = HscUtil.getCIMAssociationInst(string, cIMObjectPath, "IBMHSC_CompSysProcessor", PROCESSOR_CLASS_NAME, REF1, REF2, true, false, null);
        if (enumeration != null && enumeration.hasMoreElements()) {
            hashtable2 = new Hashtable();
            hashtable3 = new Hashtable<String, String>();
            hashtable4 = new Hashtable();
            CIMValue cIMValue = null;
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                if (cIMInstance == null) continue;
                CIMProperty cIMProperty = cIMInstance.getProperty(DEVICE_ID);
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    string2 = ((UnsignedInt8)cIMValue.getValue()).toString();
                }
                if ((cIMProperty = cIMInstance.getProperty(CPU_STATUS)) != null && (cIMValue = cIMProperty.getValue()) != null) {
                    string3 = ((UnsignedInt8)cIMValue.getValue()).toString();
                    string4 = (String)CPU_STATUS_MAP.get(string3);
                }
                if (string4 != null) {
                    hashtable3.put(string2, string4);
                } else {
                    hashtable3.put(string2, HSCResourceBundleUtil.getMessage("CECBundle", "CPU_STATUS_UNKNOWN", "Unknown"));
                }
                if (hashtable == null || !hashtable.containsKey(string2)) continue;
                hashtable4.put(string2, hashtable.get(string2));
            }
            hashtable2.put("PROCESSORS", hashtable3);
            hashtable2.put("PARTITION_ASSIGNMENT", hashtable4);
        }
        return hashtable2;
    }

    public static Hashtable getMemInfo(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = null;
        enumeration = HscUtil.getCIMAssociation(string, cIMObjectPath, COMP_LPAR_ASSO_CLASS_NAME, PARTITION_CLASS_NAME, REF1, REF2);
        if (enumeration != null) {
            String string2 = null;
            Long l = null;
            Long l2 = null;
            int n = 0;
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                CIMInstance cIMInstance = HscUtil.getCIMInstance(string, cIMObjectPath2, false);
                if (cIMInstance == null) continue;
                CIMValue cIMValue = null;
                CIMProperty cIMProperty = cIMInstance.getProperty(USER_DEFINED_NAME);
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    string2 = (String)cIMValue.getValue();
                }
                if ((cIMProperty = cIMInstance.getProperty("AllocatedMemory")) != null && (cIMValue = cIMProperty.getValue()) != null) {
                    l = new Long(((Number)cIMValue.getValue()).longValue());
                }
                if ((cIMProperty = cIMInstance.getProperty("PageTableMemory")) != null && (cIMValue = cIMProperty.getValue()) != null) {
                    l2 = new Long(((Number)cIMValue.getValue()).longValue());
                }
                if ((cIMProperty = cIMInstance.getProperty(PARTITION_STATE)) != null && (cIMValue = cIMProperty.getValue()) != null) {
                    n = ((UnsignedInt8)cIMValue.getValue()).intValue();
                }
                if (string2 == null || n != 8 && n != 9 && n != 5) continue;
                Vector<Long> vector = new Vector<Long>();
                if (l != null) {
                    vector.addElement(l);
                } else {
                    vector.addElement(new Long(0L));
                }
                if (l2 != null) {
                    vector.addElement(l2);
                } else {
                    vector.addElement(new Long(0L));
                }
                hashtable2.put(string2, vector);
            }
            hashtable.put("MEMORY", hashtable2);
        }
        return hashtable;
    }

    public static void backupData(String string, CIMObjectPath cIMObjectPath, String string2, String string3) throws CIMException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(2);
        vector.setSize(2);
        vector.setElementAt(new CIMProperty("RestoreType", new CIMValue((Object)new UnsignedInt8(4))), 0);
        vector.setElementAt(new CIMProperty("FileName", new CIMValue((Object)string3)), 1);
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "RestoreNVRAM", vector, new Vector());
    }

    public static void partitionDataRecover(String string, CIMObjectPath cIMObjectPath, Integer n) throws CIMException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(2);
        vector.add(new CIMProperty("compSystem", new CIMValue((Object)cIMObjectPath, new CIMDataType(41))));
        vector.add(new CIMProperty("RecoverType", new CIMValue((Object)new UnsignedInt8(n.shortValue()))));
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "PartitionDataRecover", vector, new Vector());
    }

    public static void restoreData(String string, CIMObjectPath cIMObjectPath, String string2, String string3, UnsignedInt8 unsignedInt8) throws CIMException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(2);
        vector.setSize(2);
        vector.setElementAt(new CIMProperty("RestoreType", new CIMValue((Object)unsignedInt8)), 0);
        vector.setElementAt(new CIMProperty("FileName", new CIMValue((Object)string3)), 1);
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "RestoreNVRAM", vector, new Vector());
    }

    public static void initializeData(String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(2);
        vector.setSize(2);
        vector.setElementAt(new CIMProperty("RestoreType", new CIMValue((Object)new UnsignedInt8(5))), 0);
        vector.setElementAt(new CIMProperty("FileName", new CIMValue((Object)" ")), 1);
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "RestoreNVRAM", vector, new Vector());
    }

    public static String getCecUserDefName(String string, String string2) throws Throwable {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HSC_COMPUTER_SYSTEM, "root/ibmhscV3_2");
        cIMObjectPath.addKey(CREATION_CLASS_NAME, new CIMValue((Object)HSC_COMPUTER_SYSTEM));
        cIMObjectPath.addKey("Name", new CIMValue((Object)string2));
        CIMValue cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath, USER_DEFINED_NAME);
        if (cIMValue != null) {
            return (String)cIMValue.getValue();
        }
        return null;
    }

    public static CIMObjectPath decodeCECKey(String string) throws HSCException {
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        Vector vector = null;
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HSC_COMPUTER_SYSTEM);
        vector = HscUtil.decodeKey(string);
        if (KEY_LIST != null) {
            enumeration = vector.elements();
            enumeration2 = KEY_LIST.elements();
            while (enumeration2.hasMoreElements()) {
                cIMObjectPath.addKey((String)enumeration2.nextElement(), new CIMValue((Object)((String)enumeration.nextElement())));
            }
        } else {
            throw new HSCException("157F");
        }
        return cIMObjectPath;
    }

    public static Vector doGetPPARSetupInfo(short s, short s2, String string, String string2) throws Exception {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(2);
        Vector<Object> vector2 = new Vector<Object>(3);
        CIMObjectPath cIMObjectPath = CECInfo.decodeCECKey(string2);
        int n = 0;
        vector.addElement(new CIMProperty(CLUSTER_SIZE, new CIMValue((Object)new UnsignedInt8(s))));
        vector.addElement(new CIMProperty(UPDATE_FLAG, new CIMValue((Object)new UnsignedInt8(s2))));
        vector2.addElement(new CIMProperty(PHYS_LOC_CODES, new CIMValue(new Vector(), new CIMDataType(29))));
        vector2.addElement(new CIMProperty(PPAR_SLOT_IDS, new CIMValue(new Vector(), new CIMDataType(29))));
        vector2.addElement(new CIMProperty(PPAR_NAMES, new CIMValue(new Vector(), new CIMDataType(29))));
        vector2.addElement(new CIMProperty(PPAR_MEM_PROBLEM_STR, new CIMValue((Object)"")));
        vector2.addElement(new CIMProperty(PPAR_PROC_PROBLEM_STR, new CIMValue((Object)"")));
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "GetPPARSetupInfo", vector, vector2);
        if (GlobalConfig.callMethodsWithValues) {
            n = 0;
            while (n < vector2.size()) {
                vector2.set(n, ((CIMValue)vector2.get(n)).getValue());
                ++n;
            }
        } else {
            n = 0;
            while (n < vector2.size()) {
                vector2.set(n, ((CIMProperty)vector2.get(n)).getValue().getValue());
                ++n;
            }
        }
        return vector2;
    }

    public static void doSetupPPAR(Hashtable[] hashtableArray, short s, short s2, String string, String string2) throws Exception {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(3);
        CIMObjectPath cIMObjectPath = CECInfo.decodeCECKey(string2);
        vector.addElement(new CIMProperty(CLUSTER_SIZE, new CIMValue((Object)new UnsignedInt8(s))));
        vector.addElement(new CIMProperty(UPDATE_FLAG, new CIMValue((Object)new UnsignedInt8(s2))));
        vector.addElement(new CIMProperty(PARTITION_INFO, new CIMValue((Object)new PparInfoPacker().packInfo(hashtableArray), new CIMDataType(29))));
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "SetupPPAR", vector, new Vector(0));
    }

    public static void doRemovePPARSetup(Integer[] integerArray, String string, String string2) throws Exception {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        UnsignedInt8[] unsignedInt8Array = null;
        CIMObjectPath cIMObjectPath = CECInfo.decodeCECKey(string2);
        int n = 0;
        unsignedInt8Array = new UnsignedInt8[integerArray.length];
        n = 0;
        while (n < integerArray.length) {
            unsignedInt8Array[n] = new UnsignedInt8(integerArray[n].shortValue());
            ++n;
        }
        vector.addElement(new CIMProperty(PPAR_SLOT_IDS, new CIMValue((Object)unsignedInt8Array, new CIMDataType(21))));
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "RemovePPARSetup", vector, new Vector(0));
    }

    public static Integer[] doGetPPARResources(short s, String string, String string2) throws Exception {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>(1);
        UnsignedInt32[] unsignedInt32Array = new UnsignedInt32[]{};
        Integer[] integerArray = null;
        CIMObjectPath cIMObjectPath = CECInfo.decodeCECKey(string2);
        int n = 0;
        vector.addElement(new CIMProperty(PPAR_SLOT_ID, new CIMValue((Object)new UnsignedInt8(s))));
        vector2.addElement(new CIMProperty(RESOURCES, new CIMValue((Object)unsignedInt32Array, new CIMDataType(25))));
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "GetPPARResources", vector, vector2);
        unsignedInt32Array = GlobalConfig.callMethodsWithValues ? ((Vector)((CIMValue)vector2.firstElement()).getValue()).toArray(unsignedInt32Array) : ((Vector)((CIMProperty)vector2.firstElement()).getValue().getValue()).toArray(unsignedInt32Array);
        integerArray = new Integer[unsignedInt32Array.length];
        n = 0;
        while (n < unsignedInt32Array.length) {
            integerArray[n] = new Integer(unsignedInt32Array[n].intValue());
            ++n;
        }
        return integerArray;
    }

    public static void doRemoveReserved(String string, String string2) throws Exception {
        CIMObjectPath cIMObjectPath = CECInfo.decodeCECKey(string2);
        HscUtil.invokeCIMMethod(string, cIMObjectPath, "RemoveReserved", new Vector(0), new Vector(0));
    }

    static {
        CPU_STATUS_MAP.put("0", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_NOT_PRESENT", "Not present"));
        CPU_STATUS_MAP.put("1", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_SYSTEM_CONFIGURED", "Configured by System"));
        CPU_STATUS_MAP.put("2", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_SYSTEM_DECONFIGURED", "Deconfigured by System"));
        CPU_STATUS_MAP.put("3", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_CUSTOMER_CONFIGURED", "Configured by User"));
        CPU_STATUS_MAP.put("4", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_CUSTOMER_DECONFIGURED", "Deconfigured by User"));
        CPU_STATUS_MAP.put("16", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_NOT_LICENSED", "Not Licensed"));
        CPU_STATUS_MAP.put("17", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_NOT_LICENSED_SYSTEM_CONFIGURED", "Not Licensed Configured by System"));
        CPU_STATUS_MAP.put("18", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_NOT_LICENSED_SYSTEM_DECONFIGURED", "Not Licensed Deconfigured by System"));
        CPU_STATUS_MAP.put("19", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_NOT_LICENSED_CUSTOMER_CONFIGURED", "Not Licensed Configured by User"));
        CPU_STATUS_MAP.put("20", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_NOT_LICENSED_CUSTOMER_DECONFIGURED", "Not Licensed Deconfigured by User"));
        CPU_STATUS_MAP.put("128", HSCResourceBundleUtil.getMessage("CECBundle", "CPU_STATUS_GOOD", "Good"));
        KEY_LIST = new Vector();
        KEY_LIST.addElement("Name");
        KEY_LIST.addElement(CREATION_CLASS_NAME);
    }
}

